﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace ITA_580
{
    public partial class Form1
    {
        public static byte TCA9554_ADDRESS = 0x40;

        public static byte TCA9554_INPUT_REG    = 0x00;
        public static byte TCA9554_OUTPUT_REG   = 0x01;
        public static byte TCA9554_POLARITY_REG = 0x02;
        public static byte TCA9554_CONFIG_REG   = 0x03;

        public static byte gTca9554 = 0;

        private void SetDioOutput(byte pin, byte level)
        {
            byte res;
            byte buf;

            if (gTca9554 == 1)
            {
                //read
                buf = 0;
                res = AecSmbReadByte(gPtrAecInit, SMBUS_CHANNEL, TCA9554_ADDRESS, TCA9554_OUTPUT_REG, ref buf);
                if (res != 0)
                {
                    MessageBox.Show("Get DIO Output Status Error ", "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
                }

                //set
                buf = (byte)((buf & ~(1 << pin)) | (level << pin));
                 res = AecSmbWriteByte(gPtrAecInit, SMBUS_CHANNEL, TCA9554_ADDRESS, TCA9554_OUTPUT_REG, ref buf);
                if (res != 0)
                {
                    MessageBox.Show("Set DIO Output Status Error ", "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
                }
            }
        }

        private void ShowDioInputStatus()
        {
            byte res;
            byte buf;
            byte[] level = new byte[4];

            if (gTca9554 == 1)
            {
                buf = 0;
                res = AecSmbReadByte(gPtrAecInit, SMBUS_CHANNEL, TCA9554_ADDRESS, TCA9554_INPUT_REG, ref buf);
                if (res != 0)
                {
                    MessageBox.Show("Get DIO Input Status Error ", "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
                }
                else
                {
                    //0:low   1:high, pin 4~7 input
                    level[0] = (byte)(buf & 0x10);
                    level[1] = (byte)(buf & 0x20);
                    level[2] = (byte)(buf & 0x40);
                    level[3] = (byte)(buf & 0x80);

                    //pin 4, gpi 1
                    if (level[0] == 0)
                    {
                        label66.Text = "Low";
                    }
                    else
                    {
                        label66.Text = "High";
                    }

                    //pin 5, gpi 2
                    if (level[1] == 0)
                    {
                        label18.Text = "Low";
                    }
                    else
                    {
                        label18.Text = "High";
                    }

                    //pin 6, gpi 3
                    if (level[2] == 0)
                    {
                        label50.Text = "Low";
                    }
                    else
                    {
                        label50.Text = "High";
                    }

                    //pin 7, gpi 4
                    if (level[3] == 0)
                    {
                        label52.Text = "Low";
                    }
                    else
                    {
                        label52.Text = "High";
                    }
                }
            }
        }

        private void ShowDioOutputStatus()
        {
            byte res;
            byte buf;
            byte[] level = new byte[4];

            if (gTca9554 == 1)
            {
                buf = 0;
                res = AecSmbReadByte(gPtrAecInit, SMBUS_CHANNEL, TCA9554_ADDRESS, TCA9554_OUTPUT_REG, ref buf);
                if (res != 0)
                {
                    MessageBox.Show("Get DIO Output Status Error ", "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
                }
                else
                {
                    //0:low   1:high, pin 0~3 output
                    level[0] = (byte)(buf & 0x01);
                    level[1] = (byte)(buf & 0x02);
                    level[2] = (byte)(buf & 0x04);
                    level[3] = (byte)(buf & 0x08);

                    //pin 0, gpo 1
                    if (level[0] == 0)
                    {
                        radioButton12.Checked = true;
                    }
                    else
                    {
                        radioButton13.Checked = true;
                    }

                    //pin 1, gpo 2
                    if (level[1] == 0)
                    {
                        radioButton15.Checked = true;
                    }
                    else
                    {
                        radioButton16.Checked = true;
                    }

                    //pin 2, gpo 3
                    if (level[2] == 0)
                    {
                        radioButton18.Checked = true;
                    }
                    else
                    {
                        radioButton19.Checked = true;
                    }

                    //pin 3, gpo 4
                    if (level[3] == 0)
                    {
                        radioButton21.Checked = true;
                    }
                    else
                    {
                        radioButton22.Checked = true;
                    }
                }
            }
        }

        private void ConfigDio()
        {
            byte res;
            byte buf;

            if (gTca9554 == 1)
            {
                buf = 0xF0;   //0:output   1:input, pin 0~3 output, pin 4~7 input
                res = AecSmbWriteByte(gPtrAecInit, SMBUS_CHANNEL, TCA9554_ADDRESS, TCA9554_CONFIG_REG, ref buf);
                if (res != 0)
                {
                    MessageBox.Show("Config DIO Error ", "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
                }
            }
        }
    }
}
